;;; -*- Mode:Common-Lisp; Package:User; Base:10; Fonts: cptfont,HL12,HL12BI,cptfontb -*-

;;;                           RESTRICTED RIGHTS LEGEND

;;;Use, duplication, or disclosure by the Government is subject to
;;;restrictions as set forth in subdivision (c)(1)(ii) of the Rights in
;;;Technical Data and Computer Software clause at 52.227-7013.
;;;
;;;                     TEXAS INSTRUMENTS INCORPORATED.
;;;                              P.O. BOX 2909
;;;                           AUSTIN, TEXAS 78769
;;;                                 MS 2151
;;;
;;; Copyright (C) 1987-1989 Texas Instruments Incorporated. All rights reserved.


1;;;*	2Cross-reference and documentation utility.

1;Version:
;  7/22/87 DNG - Original.
;  8/27/87 DNG - Change file names to lower case for System V.  Fix to not get **
;		1error in *fdefine1 if this file is loaded a second time.
;  9/17/87 DNG - Added file *"unused"1.
; 10/24/87 DNG - Export *unused-in-file1 .
; 11/24/87 DNG - Export *inverse-tree1 .
; 12/02/87 DNG - Export *show-forest1 .
; 12/17/87 DNG - Display reference to the instructions file when this is loaded.
;  1/30/88 DNG - New function *cross-reference1 .*
;1 3/3/88  * 1ab   - Finalize directory name.
; 3/23/88  LS   - Added auxiliary file *walker.xld1 so it will be copied with the system.
; 12/30/88 DNG - Export new function *document-class1.
;  1/18/89 DNG - Export *document-slot1 and **record-who-calls-info-p*1 .*

(IN-PACKAGE "DOC" :USE '("LISP" "TICL"))

(eval-when (eval compile load)
doc:
(defparameter doc-externals '(calls-who cross-reference
	  document-function document-variable document-flavor document-type document-keyword 
	  document-package document-file document-system document-class document-slot
          document  unused-in-package unused-in-file
	  build-xref-table dump-xref-table erase-xref-table
	  show-call-tree show-forest inverse-tree *record-who-calls-info-p*)
  1"User-callable functions in the *DOC1 package."*) )

(export doc:doc-externals "DOC")
(dolist (x doc:doc-externals)
  (let ((u (find-symbol (symbol-name x) *user-package*)))
    (if u
	(unless (eq u x)
	  (fdefine u x t))
      (import x *user-package*))))

(DEFSYSTEM DOCUMENTER
  (:NAME "Documenter")
  (:PATHNAME-DEFAULT "sys:documenter;")
  (:PATCHABLE "sys:patch.documenter;" patch)
  (:WARNINGS-PATHNAME-DEFAULT "SYS:CWARNS;documenter.LISP")
  
  (:MODULE DEFS ("docdefs"))	1; global variables and macros, xref-table*
  (:MODULE MAIN (
		 "find"		1; 3find-things-used-by-...**
		 "document"	1; 3document-...* functions*
		 "format"	1; output display formatting*
		 "xref"		1; 3cross-reference**
		 "tree"		1;* 3show-call-tree*
		 "unused"	1; 3unused-in-package** 1and* 3unused-in-file*
		 ))
  (:MODULE AUX ("walker.xld"))
  (:COMPILE-LOAD DEFS)
  (:COMPILE-LOAD MAIN (:FASLOAD DEFS))
  (:AUXILIARY AUX)
 )





